/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ArmorCompatibleModifier
extends Modifier
implements ToolStatsModifierHook,
TooltipModifierHook,
AttributesModifierHook {
    private static final Component MINING_SPEED = TConstruct.makeTranslation((String)"modifier", (String)"compatible.mining_speed");

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (this.isArmor(slot)) {
            consumer.accept(Attributes.f_22281_, new AttributeModifier(UUID.fromString("eba0ea2b-8738-472e-8af1-b4b68a1e82e7"), Attributes.f_22281_.m_22087_(), (double)modifier.getLevel() * 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES, ModifierHooks.TOOL_STATS, ModifierHooks.TOOLTIP);
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        ToolStats.MINING_SPEED.multiply(builder, 1.0 + 0.2 * (double)modifier.getLevel());
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag(TinkerTags.Items.ARMOR) && (boost = 0.1 * (double)modifier.getLevel()) != 0.0) {
            tooltip.add((Component)this.applyStyle(Component.m_237115_((String)Util.PERCENT_BOOST_FORMAT.format(boost)).m_130946_(" ").m_7220_(MINING_SPEED)));
        }
    }
}

